<?php
/*============================================================================*\
|| ########################################################################## ||
|| # Ultimate Media Gallery v1.4.3                                          # ||
|| #                                                                        # ||
|| # ---------------------------------------------------------------------- # ||
|| # Copyright  2008-2009 pHp-unlimited. All Rights Reserved.              # ||
|| # This file may not be redistributed in whole or significant part.       # ||
|| # It's not allowed to delete this Information.                           # ||
|| ########################################################################## ||
\*============================================================================*/

// ISO												= ISOSpeedRatings				(z.B. 200)									= 200
// Verschlusszeit							= ExposureTime					(z.B. 1/80)									= 1/80
// EXIF
// Brennweite        					= FocalLength						(z.B. 97/10)								= 9.7
// max. Blendenwert 				  = ApertureFNumber				(z.B. f/2.8)								= f/2.8
// max. Blendenwert  					= FNumber								(z.B. 28/10)								= 2.8
// Erstellungs Datum					= DateTimeOriginal			(z.B. 2005:11:27 17:34:59)
// nderungs Datum						= DateTimeDigitized			(z.B. 2005:11:27 17:34:59)
// Belichtungsmodus						= ExposureProgram   		(z.B. 2)
//																												0 = not defined
//																												1 = manuel
//																												2 = Normal program
//																												3 = Aperture priority
//																												4 = Shutter priority
//																												5 = Creative program
//																												6 = Action program
//																												7 = Portrait mode
//																												8 = Landscape mode
// Lichtquelle								= LightSource						(z.B. 0)
//																											  0 = Unbekanntes
//																							  				1 = Tageslicht
//																							  				2 = Leuchtstoff
//																											  3 = Wolfram
//																											  4 = Blitz
//																											  9 = schnes Wetter
//																											 10 = bewlktes Wetter
//																											 11 = Farbton
//																											 12 = Tageslicht Leuchtstoff
//																											 13 = Tagesweies Leuchtstoff
//																											 14 = khles weies Leuchtstoff 
//																											 15 = weies Leuchtstoff
//																											 17 = Standardlicht A
//																											 18 = Standardlicht B
//																											 19 = Standardlicht C
//																											 20 = D55
//																											 21 = D65
//																											 22 = D75
//																											 23 = D50
//																											 24 = ISO-Studiowolfram
//																											255 = andere Lichtquelle
// Brennweite bei 35mm Filmen	= FocalLengthIn35mmFilm	(z.B. 63)				= 63mm
// Weissabgleich							= WhiteBalance					(z.B. 0)
//																												0 = auto
//																												1 = manuel
// DigitalZoom     						= DigitalZoomRatio			(z.B. 0/100)								= 0/100
// Szene											= SceneCaptureType			(z.B. 0)
//																												0 = Standard
//																												1 = Landscape  / Landschaft
//																												2 = Portrait
//																												3 = Nachtszene / Night scene
// Blitz Einstellung					= Flash									(z.B. 25)
//																												Bit 0
//																														00 = ohne Blitz
//																														01 = mit Blitz
//																												Bit 1 & 2
//																														00 = No strobe return detection function
//																														01 = reserved
//																														10 = Strobe return light not detected
//																														11 = Strobe return light detected 
//																												Bit 3 & 4
//																														00 = unknown
//																														01 = Compulsory flash firing
//																														10 = Compulsory flash suppression
//																														11 = Auto mode 
//																												Bit 5
//																														00 = Flash function present
//																														01 = No flash function 
//																												Bit 6 (only for cameras with Red-eye reductions)
//																														00 = No red-eye reduction mode or unknown
//																														01 = Red-eye reduction supported
// ----
//																														hex 0000 = Flash did not fire
//																														hex 0001 = Flash fired
//																														hex 0005 = Strobe return light not detected
//																														hex 0007 = Strobe return light detected
//																														hex 0009 = Flash fired, compulsory flash mode
//																														hex 000D = Flash fired, compulsory flash mode, return light not detected
//																														hex 000F = Flash fired, compulsory flash mode, return light detected
//																														hex 0010 = Flash did not fire, compulsory flash mode
//																														hex 0018 = Flash did not fire, auto mode
//																														hex 0019 = Flash fired, auto mode
//																														hex 001D = Flash fired, auto mode, return light not detected
//																														hex 001F = Flash fired, auto mode, return light detected
//																														hex 0020 = No flash function
//																														hex 0041 = Flash fired, red-eye reduction mode
//																														hex 0045 = Flash fired, red-eye reduction mode, return light not detected
//																														hex 0047 = Flash fired, red-eye reduction mode, return light detected
//																														hex 0049 = Flash fired, compulsory flash mode, red-eye reduction mode
//																														hex 004D = Flash fired, compulsory flash mode, red-eye reduction mode, return light not detected
//																														hex 004F = Flash fired, compulsory flash mode, red-eye reduction mode, return light detected
//																														hex 0059 = Flash fired, auto mode, red-eye reduction mode
//																														hex 005D = Flash fired, auto mode, return light not detected, red-eye reduction mode
//																														hex 005F = Flash fired, auto mode, return light detected, red-eye reduction mode 
// Auflsung									= XResolution						(z.B. 72/1)								 = 72ppi
// Kontrast										= Contrast							(z.B. 0)
//																												0 = Normal
//																												1 = Soft
//																												2 = Hard
// Schrfe										= Sharpness							(z.B. 0)
//																												0 = Normal
//																												1 = Soft
//																												2 = Hard
// Sttigung									= Saturation						(z.B. 0)
//																												0 = Normal
//																												1 = Low saturation
//																												2 = High saturation
// Belichtungsmodus						= ExposureMode					(z.B. 0)
//																												0 = Auto exposure
//																												1 = Manuel exposure
//																												2 = Auto bracket

$search_array = array ('FILE', 'COMPUTED', 'IFD0', 'THUMBNAIL', 'EXIF', 'INTEROP');
$section_array = array (
	'FILE' => array (
		'FileName',
		'FileDateTime',
		'FileSize',
		'FileType',
		'MimeType'
	),
	'COMPUTED' => array (
		'html',
		'Height',
		'Width',
		'IsColor',
		'ByteOrderMotorola',
		'ApertureFNumber'
	),
	'IFD0' => array (
		'ImageDescription',
		'Make',
		'Model',
		'Orientation',
		'XResolution',
		'YResolution',
		'ResolutionUnit',
		'Software',
		'DateTime',
		'YCbCrPositioning'
	),
	'THUMBNAIL' => array (
		'Compression',
		'Orientation',
		'XResolution',
		'YResolution',
		'ResolutionUnit',
		'JPEGInterchangeFormat',
		'JPEGInterchangeFormatLength',
		'YCbCrPositioning'
	),
	'EXIF' => array (
		'ExposureTime',
		'FNumber',
		'ExposureProgram',
		'ISOSpeedRatings',
		'DateTimeOriginal',
		'DateTimeDigitized',
		'ShutterSpeedValue',
		'ApertureValue',
		'ExposureBiasValue',
		'MaxApertureValue',
		'MeteringMode',
		'LightSource',
		'Flash',
		'FocalLength',
		'FlashPixVersion',
		'ColorSpace',
		'InteroperabilityOffset',
		'CustomRendered',
		'ExposureMode',
		'WhiteBalance',
		'DigitalZoomRatio',
		'FocalLengthIn35mmFilm',
		'SceneCaptureType',
		'Contrast',
		'Saturation',
		'Sharpness'
	),
	'INTEROP' => array (
		'InterOperabilityIndex',
		'InterOperabilityVersion'
	)
);

$image_exif_data = array ();
if ($vbulletin->options['umgexif_active'] AND $filename AND in_array ($extension, array ('jpg', 'tiff')))
{
	// create our array for some values
	$exposure = array (
		'not defined',
		'manuel', 
		'Normal program',
		'Aperture priority',
		'Shutter priority',
		'Creative program',
		'Action program',
		'Portrait mode',
		'Landscape mode'
	);
	$lightsource = array (
		'Undefined',
		'Daylight',
		'Fluorescent',
		'Tungsten',
		'Flash',
		'Fine weather',
		'Cloudy weather',
		'Shade',
		'Daylight fluorescent',
		'Day white fluorescent',
		'Color white fluorescent',
		'White fluorescent',
		'Standard light A',
		'Standard light B',
		'Standard light C',
		'D55',
		'D65',
		'D75',
		'D50',
		'ISO studio tungsten',
		'other light source'
	);
	$whitebalance = array (
		'auto',
		'manuel'
	);
	$scene = array (
		'Standard',
		'Landscape',
		'Portrait',
		'Night scene'
	);
	$contrast = array (
		'Normal',
		'Soft',
		'Hard'
	);
	$sharpness = array (
		'Normal',
		'Soft',
		'Hard'
	);
	$saturation = array (
		'Normal',
		'Low saturation',
		'High saturation'
	);
	$exposuremode = array (
		'Auto exposure',
		'Manual exposure',
		'Auto bracket'
	);
	$flash = array (
		'Flash did not fire',
		'Flash fired',
		'','','',
		'Strobe return light not detected',
		'',
		'Strobe return light detected',
		'',
		'Flash fired, compulsory flash mode',
		'','','',
		'Flash fired, compulsory flash mode, return light not detected',
		'',
		'Flash fired, compulsory flash mode, return light detected',
		'Flash did not fire, compulsory flash mode',
		'','','','','','','',
		'Flash did not fire, auto mode',
		'Flash fired, auto mode',
		'','','',
		'Flash fired, auto mode, return light not detected',
		'',
		'Flash fired, auto mode, return light detected',
		'No flash function',
		'','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',
		'Flash fired, red-eye reduction mode',
		'','','','',
		'Flash fired, red-eye reduction mode, return light not detected',
		'',
		'Flash fired, red-eye reduction mode, return light detected',
		'',
		'Flash fired, compulsory flash mode, red-eye reduction mode',
		'','','',
		'Flash fired, compulsory flash mode, red-eye reduction mode, return light not detected',
		'',
		'Flash fired, compulsory flash mode, red-eye reduction mode, return light detected',
		'','','','','','','','','',
		'Flash fired, auto mode, red-eye reduction mode',
		'','','',
		'Flash fired, auto mode, return light not detected, red-eye reduction mode',
		'',
		'Flash fired, auto mode, return light detected, red-eye reduction mode'
	);
	// get the informations for EXIF
	$image_data = @exif_read_data ($filename, 'IFD0,THUMBNAIL,EXIF', 1);
	if (is_array ($image_data))
	{
		foreach ($image_data AS $key => $section)
		{
			if (in_array ($key, $search_array))
			{
				$new_search = $section_array[$key];
				if (is_array ($section))
				{
					foreach ($section AS $subs => $value)
					{
						if (in_array ($subs, $new_search))
						{
							$opt = 'umgexif_' . strtolower ($subs);
							if ($vbulletin->options["$opt"])
							{
								if ($subs == 'ExposureProgram')
								{
									$value = $exposure["$value"];
								}
								else if ($subs == 'LightSource')
								{
									$value = $lightsource["$value"];
								}
								else if ($subs == 'Contrast')
								{
									$value = $contrast["$value"];
								}
								else if ($subs == 'Saturation')
								{
									$value = $saturation["$value"];
								}
								else if ($subs == 'Sharpness')
								{
									$value = $sharpness["$value"];
								}
								else if ($subs == 'ExposureMode')
								{
									$value = $exposuremode["$value"];
								}
								else if ($subs == 'WhiteBalance')
								{
									$value = $whitebalance["$value"];
								}
								else if ($subs == 'SceneCaptureType')
								{
									$value = $scene["$value"];
								}
								else if ($subs == 'Flash')
								{
									$value = $flash["$value"];
								}
								else if ($subs == 'FNumber' OR $subs == 'FocalLength')
								{
									$v = explode ('/', $value);
									$value = $v[0] / $v[1];
								}
								else if ($subs == 'XResolution')
								{
									$v = explode ('/', $value);
									$value = ($v[0] / $v[1]) . 'mm';
								}
								$image_exif_data[$subs] = $value;
							}
						}
					}
				}
			}
		}
	}

}
?>
